

*Tim Goedemé



global place1 ...\EU-SILC\Cross\2020-04\
global place2 ...\social class and poverty\StataOutput\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

*******************

local rownames
cap mat drop results
foreach ctry of global countries {
	di "`ctry'"
	
	quietly {
		forvalues year=2004(1)2018 {
			cap mat drop tempmat1
			noi di "`year'", _continue
			cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta"
			if _rc==0 {
				
				use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
				cap drop _merge
				merge 1:1 pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
				
				drop _merge
				
				svyset psu1 [pw=rb050], strata(strata1)
				
				gen labinc = (earns2!=0) if earns2!=.
				count if labinc==1
				
				if r(N)>20 {
					bysort hid: egen hlabinc = sum(labinc)
					replace hlabinc=1 if hlabinc>1
					submean2 hlabinc, na(res)
					
					mat def tempmat1  = `year', res
					mat def results = nullmat(results) \ tempmat1
					local rownames `rownames' `ctry'
				}
			}
		}
	}
}
mat rownames results = `rownames'
mat li results


*Export data
local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	global names: rownames res_`v'1
	clear
	mat colnames res_`v'1 = Estimate STE DF LB UB Povline category year
	svmat res_`v'1, names(col)
	gen country=""
	local counter
	foreach r of global names {
	    local counter=`counter'+1
	    replace country="`r'" in `counter'
	}
	gen esec="`v'"
	compress
	save "${place2}\AROP60res_`v'_5.dta", replace
}
